/*
 * QrfeEM4325Tag.cpp
 *
 *  Created on: 08.10.2013
 *      Author: stefan.detter
 */

#include "../inc/tag/specific/QrfeNXPTag.h"

#include "../inc/QrfeReaderInterface.h"

/** Definition for EPC wordpointer: Address for NXP config word */
#define MEMADR_NXP_CONFIG 	0x20
/** Definition for EPC wordpointer: Address for NXP download register */
#define MEMADR_NXP_DOWNLOAD 0x1F

QrfeNXPTag::QrfeNXPTag(QString tagId, QrfeGen2AdvancedManipulatorInterface* reader, QObject* parent)
	: QrfeGen2Tag(tagId, reader, parent)
{
}

QrfeNXPTag::~QrfeNXPTag()
{
}


QrfeGlobal::TMIResult QrfeNXPTag::nxp_setReadProtect ( QByteArray passwd )
{
    return ((QrfeGen2AdvancedManipulatorInterface*)m_gen2reader)->nxp_setReadProtect(m_tagId, passwd);
}

QrfeGlobal::TMIResult QrfeNXPTag::nxp_resetReadProtect ( QByteArray passwd )
{
    return ((QrfeGen2AdvancedManipulatorInterface*)m_gen2reader)->nxp_resetReadProtect(m_tagId, passwd);
}

QrfeGlobal::TMIResult QrfeNXPTag::nxp_sendCmdToCtrler ( uchar cmd, QByteArray cmdData )
{
    return ((QrfeGen2AdvancedManipulatorInterface*)m_gen2reader)->nxp_sendCmdToCtrler(m_tagId, cmd, cmdData);
}

QrfeGlobal::TMIResult QrfeNXPTag::nxp_readConfigWord ( QByteArray passwd, ushort &word )
{
    QrfeGlobal::TMIResult res = QrfeGlobal::TMI_ERROR;

    QByteArray result;

    res = readFromTag(QrfeGen2Tag::MEM_EPC, MEMADR_NXP_CONFIG, passwd, 2, result);

    if(res == QrfeGlobal::TMI_OK)
        word = (((ushort)result.at(0)) << 8) + result.at(1);

    return res;
}

QrfeGlobal::TMIResult QrfeNXPTag::nxp_writeConfigWord ( QByteArray passwd, ushort word )
{
    QByteArray data;

    data.append((uchar)(word >> 8));
    data.append((uchar)(word));

    return writeToTag(QrfeGen2Tag::MEM_EPC, MEMADR_NXP_CONFIG, passwd, data, false);
}

QrfeGlobal::TMIResult QrfeNXPTag::nxp_readDownloadRegister ( QByteArray passwd, ushort &word )
{
    QrfeGlobal::TMIResult res = QrfeGlobal::TMI_ERROR;

    QByteArray result;

    res = readFromTag(QrfeGen2Tag::MEM_EPC, MEMADR_NXP_DOWNLOAD, passwd, 2, result);

    if(res == QrfeGlobal::TMI_OK)
        word = (((ushort)result.at(0)) << 8) + result.at(1);

    return res;
}

QrfeGlobal::TMIResult QrfeNXPTag::nxp_writeDownloadRegister ( QByteArray passwd, ushort word )
{
    QByteArray data;

    data.append((uchar)(word >> 8));
    data.append((uchar)(word));

    return writeToTag(QrfeGen2Tag::MEM_EPC, MEMADR_NXP_DOWNLOAD, passwd, data);
}
